VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "TDALIBallast"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "This Object repesents one single Ballast in the DALI Bus"
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private iShortAddress As Byte
Private iLightLevel As Byte
Private iFadeRate As Byte
Private iFadeTime As Byte

Public Event CommError()
Public Selected As Boolean

Public Property Let FadeRate(NewFR As Byte)
  DALIBus.Send DALI_SetDTR, data:=NewFR
  DALIBus.Send DALI_StoreDTRAsFadeRate, DALI_AD_SHORT + iShortAddress
  iFadeRate = NewFR
End Property

Public Property Get FadeRate() As Byte
  FadeRate = iFadeRate
End Property

Public Property Let FadeTime(NewFT As Byte)
  DALIBus.Send DALI_SetDTR, data:=NewFT
  DALIBus.Send DALI_StoreDTRAsFadeTime, DALI_AD_SHORT + iShortAddress
  iFadeTime = NewFT
End Property

Public Property Get FadeTime() As Byte
  FadeTime = iFadeTime
End Property

Public Property Get idx() As Byte
  idx = iShortAddress
End Property

Public Property Let LightLevel(ByVal vData As Byte)
Attribute LightLevel.VB_Description = "Current Dim Level"
  iLightLevel = vData
  DALIBus.Send DALI_DirectArcPowerControl, DALI_AD_SHORT + iShortAddress, vData
End Property

Public Property Get LightLevel() As Byte
  LightLevel = iLightLevel
End Property

Public Sub DimDown()
  DALIBus.Send DALI_Down, DALI_AD_SHORT + iShortAddress
End Sub

Public Sub DimUp()
  DALIBus.Send DALI_Up, DALI_AD_SHORT + iShortAddress
End Sub

Public Property Let ShortAddress(ByVal vData As Byte)
Attribute ShortAddress.VB_Description = "Short Address of the Ballast"
  Dim zwfade As Byte
  iShortAddress = vData
  zwfade = DALIBus.Send(DALI_QueryFadeTimeFadeRate, DALI_AD_SHORT + iShortAddress)
  iFadeTime = zwfade \ 16
  iFadeRate = zwfade Mod 16
End Property

Public Property Get ShortAddress() As Byte
  ShortAddress = iShortAddress
End Property

Public Sub SetLightLevelNoDALI(newll As Byte)
  iLightLevel = newll
End Sub

Public Sub UpdateLightLevelFromDALI()
  iLightLevel = DALIBus.Send(DALI_QueryActualLevel, DALI_AD_SHORT + iShortAddress)
End Sub

Public Function BelongsToGroup(Group As Byte) As Boolean
  Dim Groups As Long
  Groups = DALIBus.Send(DALI_QueryGroups_0_7, DALI_AD_SHORT + iShortAddress)
  Groups = DALIBus.Send(DALI_QueryGroups_8_15, DALI_AD_SHORT + iShortAddress) * 256 + Groups
  If (Groups And (2 ^ Group)) = 0 Then
    BelongsToGroup = False
  Else
    BelongsToGroup = True
  End If
End Function

Public Sub GoToScene(Scene As Byte)
  DALIBus.Send DALI_GoToScene, DALI_AD_SHORT + iShortAddress, Scene
  UpdateLightLevelFromDALI
End Sub

Public Sub StoreActAsScene(Scene As Byte)
  DALIBus.Send DALI_StoreActLevelToDTR, DALI_AD_SHORT + iShortAddress, Scene
  DALIBus.Send DALI_StoreDTRAsSceneLevel, DALI_AD_SHORT + iShortAddress, Scene
End Sub

Public Sub DeleteScene(Scene As Byte)
  DALIBus.Send DALI_SetDTR, data:=255 'Store MASK to Scene reg
  DALIBus.Send DALI_StoreDTRAsSceneLevel, DALI_AD_SHORT + iShortAddress, Scene
End Sub

Public Sub AddToGroup(Group As Byte)
  DALIBus.Send DALI_AddToGroup, DALI_AD_SHORT + iShortAddress, Group
End Sub

Public Sub RemoveFromGroup(Group As Byte)
  DALIBus.Send DALI_RemoveFromGroup, DALI_AD_SHORT + iShortAddress, Group
End Sub

Private Sub Class_Initialize()
  Selected = False
End Sub

Public Sub Reset()
  DALIBus.Send DALI_Reset, DALI_AD_SHORT + iShortAddress
  UpdateLightLevelFromDALI
End Sub
